# Vertragsnummer- und Bezeichnungsgeneratoren

Vertragsnummern und Bezeichnungen werden auf Basis von Generatoren erzeugt. Jeder Generator basiert dabei auf einem Template, welches mithilfe von Daten des Vertrags bspw. die Vertragsnummer erzeugt. Weitere Informationen zu Nummern und Bezeichnungen gibt <a
href="#!/guide/pEB586201_2285_4D03_9D72_4F799451178E">Vertrag (Vertragsakte)</a>.

<span class="tag_important">Welcher Vertragsnummern und Bezeichnungsgenerator bei der Erzeugung einer neuen Akte eingesetzt wird, muss in der Konfiguration des <a
href="#!/guide/p7B9917EA_3551_445E_A621_AF59E23AE8DF">Vertragstyps</a> hinterlegt werden.</span>

{@img img1.png}

Informationen, u.a. zu den verfügbaren Template Helpers (Handlebars.js) und zu Möglichkeiten des Templating, gibt die Klasse `sol.common.Template`. Nachfolgend werden einige Beispiele erläutert.

Mithilfe der Template-Syntax `{{ }}` kann auf Informationen des Vertrags über das Objekt `sord` zugegriffen werden. Grundlage hierfür ist eine Transformation des ELO-Indexserver-Sord-Objektes durch die Klasse `sol.common.ObjectFormatter`.

## Vertragsnummerngenerator

Generatoren für die Vertragsnummer müssen als Text-Dateien unter `\Administration\Business Solutions Custom\contract\Configuration\Generators\Contract no.\` hinterlegt werden.

Vertragsnummern können mithilfe des Template-Helpers `count` erzeugt werden. Dieser erwartet einen Nummernkreis (hier: `sol.contract.ContractNo`) sowie optional der Möglichkeit eine Zahl mit einer vorgegebenen Anzahl von Stellen zu erzeugen (hier <span
style='font-weight:bold;font-style:italic'>000000</span>). 

    C{{count "sol.contract.ContractNo" "000000"}}
     
    // Ergebnisse:
    // C000001
    // C000002

Soll der Vertragstyp (Indexfeld: `CONTRACT_TYPE`) mit in den Nummerkreis aufgenommen werden, kann der Vertragsnummerngenerator wie folgt erweitert werden.

    C-{{sord.objKeys.CONTRACT_TYPE}}-{{count "sol.contract.ContractNo.{{sord.objKeys.CONTRACT_TYPE}}" "000000"}}
     
    // Ergebnisse:
    // C-Abonnement-000001
    // C-Abonnement-000002
    // C-Wartungsvertrag-000001

<span class="tag_important">Bei der Erzeugung eigener Nummerngeneratoren sollte darauf geachtet werden, alle Informationen des Nummernkreises mit in die Vertragsnummer aufzunehmen. Andernfalls kann es zur Erzeugung doppelter Nummern kommen.</span>

## Vertragsbezeichnung

Generatoren für die Vertragsbezeichnung (Kurzbezeichnung) müssen als Text-Dateien unter `\Administration\Business Solutions Custom\contract\Configuration\Generators\Contract short description\` hinterlegt werden.

Dabei kann auf alle Informationen des Vertrags zugegriffen werden. Nachfolgendes Beispiel zeigt den Standard in dem die Vertragsnummer sowie der Vertragsname aufgenommen wird.

    {{sord.objKeys.CONTRACT_NO}} {{sord.objKeys.CONTRACT_NAME}}
